/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.util.Arrays;

public class ShortArray {
    public short[] items;
    public int size;
    public boolean ordered;

    public ShortArray() {
        this(true, 16);
    }

    public ShortArray(int capacity) {
        this(true, capacity);
    }

    public ShortArray(boolean ordered, int capacity) {
        this.ordered = ordered;
        this.items = new short[capacity];
    }

    public ShortArray(ShortArray array) {
        this.ordered = array.ordered;
        this.size = array.size;
        this.items = new short[this.size];
        System.arraycopy(array.items, 0, this.items, 0, this.size);
    }

    public ShortArray(short[] array) {
        this(true, array, 0, array.length);
    }

    public ShortArray(boolean ordered, short[] array, int startIndex, int count2) {
        this(ordered, count2);
        this.size = count2;
        System.arraycopy(array, startIndex, this.items, 0, count2);
    }

    public void add(int value2) {
        short[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size++] = (short)value2;
    }

    public void add(short value2) {
        short[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        items[this.size++] = value2;
    }

    public void addAll(ShortArray array) {
        this.addAll(array, 0, array.size);
    }

    public void addAll(ShortArray array, int offset, int length) {
        if (offset + length > array.size) {
            throw new IllegalArgumentException("offset + length must be <= size: " + offset + " + " + length + " <= " + array.size);
        }
        this.addAll(array.items, offset, length);
    }

    public void addAll(short ... array) {
        this.addAll(array, 0, array.length);
    }

    public void addAll(short[] array, int offset, int length) {
        int sizeNeeded = this.size + length;
        short[] items = this.items;
        if (sizeNeeded > items.length) {
            items = this.resize(Math.max(8, (int)((float)sizeNeeded * 1.75f)));
        }
        System.arraycopy(array, offset, items, this.size, length);
        this.size += length;
    }

    public short get(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index2 + " >= " + this.size);
        }
        return this.items[index2];
    }

    public void set(int index2, short value2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index2 + " >= " + this.size);
        }
        this.items[index2] = value2;
    }

    public void incr(int index2, short value2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index2 + " >= " + this.size);
        }
        int n = index2;
        this.items[n] = (short)(this.items[n] + value2);
    }

    public void mul(int index2, short value2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index2 + " >= " + this.size);
        }
        int n = index2;
        this.items[n] = (short)(this.items[n] * value2);
    }

    public void insert(int index2, short value2) {
        if (index2 > this.size) {
            throw new IndexOutOfBoundsException("index can't be > size: " + index2 + " > " + this.size);
        }
        short[] items = this.items;
        if (this.size == items.length) {
            items = this.resize(Math.max(8, (int)((float)this.size * 1.75f)));
        }
        if (this.ordered) {
            System.arraycopy(items, index2, items, index2 + 1, this.size - index2);
        } else {
            items[this.size] = items[index2];
        }
        ++this.size;
        items[index2] = value2;
    }

    public void swap(int first, int second) {
        if (first >= this.size) {
            throw new IndexOutOfBoundsException("first can't be >= size: " + first + " >= " + this.size);
        }
        if (second >= this.size) {
            throw new IndexOutOfBoundsException("second can't be >= size: " + second + " >= " + this.size);
        }
        short[] items = this.items;
        short firstValue = items[first];
        items[first] = items[second];
        items[second] = firstValue;
    }

    public boolean contains(short value2) {
        int i = this.size - 1;
        short[] items = this.items;
        while (i >= 0) {
            if (items[i--] != value2) continue;
            return true;
        }
        return false;
    }

    public int indexOf(short value2) {
        short[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(char value2) {
        short[] items = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (items[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public boolean removeValue(short value2) {
        short[] items = this.items;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            if (items[i] != value2) continue;
            this.removeIndex(i);
            return true;
        }
        return false;
    }

    public short removeIndex(int index2) {
        if (index2 >= this.size) {
            throw new IndexOutOfBoundsException("index can't be >= size: " + index2 + " >= " + this.size);
        }
        short[] items = this.items;
        short value2 = items[index2];
        --this.size;
        if (this.ordered) {
            System.arraycopy(items, index2 + 1, items, index2, this.size - index2);
        } else {
            items[index2] = items[this.size];
        }
        return value2;
    }

    public void removeRange(int start, int end) {
        if (end >= this.size) {
            throw new IndexOutOfBoundsException("end can't be >= size: " + end + " >= " + this.size);
        }
        if (start > end) {
            throw new IndexOutOfBoundsException("start can't be > end: " + start + " > " + end);
        }
        short[] items = this.items;
        int count2 = end - start + 1;
        if (this.ordered) {
            System.arraycopy(items, start + count2, items, start, this.size - (start + count2));
        } else {
            int lastIndex = this.size - 1;
            for (int i = 0; i < count2; ++i) {
                items[start + i] = items[lastIndex - i];
            }
        }
        this.size -= count2;
    }

    public boolean removeAll(ShortArray array) {
        int size2;
        int startSize = size2 = this.size;
        short[] items = this.items;
        int n = array.size;
        block0: for (int i = 0; i < n; ++i) {
            short item = array.get(i);
            for (int ii = 0; ii < size2; ++ii) {
                if (item != items[ii]) continue;
                this.removeIndex(ii);
                --size2;
                continue block0;
            }
        }
        return size2 != startSize;
    }

    public short pop() {
        return this.items[--this.size];
    }

    public short peek() {
        return this.items[this.size - 1];
    }

    public short first() {
        if (this.size == 0) {
            throw new IllegalStateException("Array is empty.");
        }
        return this.items[0];
    }

    public void clear() {
        this.size = 0;
    }

    public short[] shrink() {
        if (this.items.length != this.size) {
            this.resize(this.size);
        }
        return this.items;
    }

    public short[] ensureCapacity(int additionalCapacity) {
        int sizeNeeded = this.size + additionalCapacity;
        if (sizeNeeded > this.items.length) {
            this.resize(Math.max(8, sizeNeeded));
        }
        return this.items;
    }

    protected short[] resize(int newSize) {
        short[] newItems = new short[newSize];
        short[] items = this.items;
        System.arraycopy(items, 0, newItems, 0, Math.min(this.size, newItems.length));
        this.items = newItems;
        return newItems;
    }

    public void sort() {
        Arrays.sort(this.items, 0, this.size);
    }

    public void reverse() {
        short[] items = this.items;
        int lastIndex = this.size - 1;
        int n = this.size / 2;
        for (int i = 0; i < n; ++i) {
            int ii = lastIndex - i;
            short temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public void shuffle() {
        short[] items = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            int ii = MathUtils.random(i);
            short temp = items[i];
            items[i] = items[ii];
            items[ii] = temp;
        }
    }

    public void truncate(int newSize) {
        if (this.size > newSize) {
            this.size = newSize;
        }
    }

    public short random() {
        if (this.size == 0) {
            return 0;
        }
        return this.items[MathUtils.random(0, this.size - 1)];
    }

    public short[] toArray() {
        short[] array = new short[this.size];
        System.arraycopy(this.items, 0, array, 0, this.size);
        return array;
    }

    public int hashCode() {
        if (!this.ordered) {
            return super.hashCode();
        }
        short[] items = this.items;
        int h = 1;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            h = h * 31 + items[i];
        }
        return h;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!this.ordered) {
            return false;
        }
        if (!(object instanceof ShortArray)) {
            return false;
        }
        ShortArray array = (ShortArray)object;
        if (!array.ordered) {
            return false;
        }
        int n = this.size;
        if (n != array.size) {
            return false;
        }
        short[] items1 = this.items;
        short[] items2 = array.items;
        for (int i = 0; i < n; ++i) {
            if (this.items[i] == array.items[i]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.size == 0) {
            return "[]";
        }
        short[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('[');
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(", ");
            buffer.append(items[i]);
        }
        buffer.append(']');
        return buffer.toString();
    }

    public String toString(String separator) {
        if (this.size == 0) {
            return "";
        }
        short[] items = this.items;
        StringBuilder buffer = new StringBuilder(32);
        buffer.append(items[0]);
        for (int i = 1; i < this.size; ++i) {
            buffer.append(separator);
            buffer.append(items[i]);
        }
        return buffer.toString();
    }

    public static ShortArray with(short ... array) {
        return new ShortArray(array);
    }
}

